/* SigmaStar trade secret */
/* Copyright (c) [2019~2020] SigmaStar Technology.
All rights reserved.

Unless otherwise stipulated in writing, any and all information contained
herein regardless in any format shall remain the sole proprietary of
SigmaStar and be kept in strict confidence
(SigmaStar Confidential Information) by the recipient.
Any unauthorized act including without limitation unauthorized disclosure,
copying, use, reproduction, sale, distribution, modification, disassembling,
reverse engineering and compiling of the contents of SigmaStar Confidential
Information is unlawful and strictly prohibited. SigmaStar hereby reserves the
rights to any and all damages, losses, costs and expenses resulting therefrom.
*/

#include "sys_sys_isw_cli.h"
#include "cam_proc_wrapper.h"
#include "cam_os_wrapper.h"

/*  This file is an example about how to create and remove below nodes/entries :
 *  /VENC/
 *  /VENC/FPS
 *  /VENC/Entry1/
 *  /VENC/Entry1/Resolution
 *  /VENC/Entry1/Entry2/
 *  /VENC/Entry1/Entry2/Bitrate
 *  /VDEC/
 *  /VDEC/Dec_FPS
 *  /VDEC/Dec_Res
 *  /VDEC/Dec_VBR
 */

//==================VENC==================
struct CamProcDirEntry_t *gpVENCRootDir;
struct CamProcDirEntry_t *gpVENCSubDir1;
struct CamProcDirEntry_t *gpVENCSubDir2;

u32 gVencFpsVal = 30;
u32 gVencResolutionW = 1920;
u32 gVencResolutionH = 1080;
u32 gVencBitrateVal = 8*1024*1024;

void VENCFpsCat(CamProcSeqBuf_t *pProcBuf, int nLen)
{
    CamProcPrintf(pProcBuf,"VENC FPS is %d\n",gVencFpsVal);
}
void VENCFpsEcho(char *pProcBuf, int nLen)
{
    CamOsPrintf("VENC pProcBuf=%s,len=%d\n",pProcBuf,nLen);
    gVencFpsVal = atoi(pProcBuf);
}

void VENCResolutionCat(CamProcSeqBuf_t *pProcBuf, int nLen)
{
    CamProcPrintf(pProcBuf,"VENC Resolution is %dx%d\n",gVencResolutionW,gVencResolutionH);
}
void VENCResolutionEcho(char *pProcBuf, int nLen)
{
    CamOsPrintf("VENC pProcBuf=%s,len=%d\n",pProcBuf,nLen);
    gVencResolutionW = atoi(pProcBuf);
    pProcBuf = strchr(pProcBuf,' ');
    pProcBuf++;// skip space
    gVencResolutionH = atoi(pProcBuf);
}

void VENCBitrateCat(CamProcSeqBuf_t *pProcBuf, int nLen)
{
    CamProcPrintf(pProcBuf,"VENC bitrate is %d\n",gVencBitrateVal);
}
void VENCBitrateEcho(char *pProcBuf, int nLen)
{
    CamOsPrintf("VENC pProcBuf=%s,len=%d\n",pProcBuf,nLen);
    gVencBitrateVal = atoi(pProcBuf);
}

//==================VDEC==================
struct CamProcDirEntry_t *gpVDECRootDir;
u32 gVDecFpsVal = 25;
u32 gVDecResolutionW = 1280;
u32 gVDecResolutionH = 720;
u32 gVDecBitrateVal = 16*1024*1024;

void VDECFpsCat(CamProcSeqBuf_t *pProcBuf, int nLen)
{
    CamProcPrintf(pProcBuf,"VDEC FPS is %d\n",gVDecFpsVal);
}
void VDECFpsEcho(char *pProcBuf, int nLen)
{
    CamOsPrintf("VDEC pProcBuf=%s,len=%d\n",pProcBuf,nLen);
    gVDecFpsVal = atoi(pProcBuf);
}

void VDECResolutionCat(CamProcSeqBuf_t *pProcBuf, int nLen)
{
    CamProcPrintf(pProcBuf,"VDEC Resolution is %dx%d\n",gVDecResolutionW,gVDecResolutionH);
}
void VDECResolutionEcho(char *pProcBuf, int nLen)
{
    CamOsPrintf("VDEC pProcBuf=%s,len=%d\n",pProcBuf,nLen);
    gVDecResolutionW = atoi(pProcBuf);
    pProcBuf = strchr(pProcBuf,' ');
    pProcBuf++;// skip space
    gVDecResolutionH = atoi(pProcBuf);
}

void VDECBitrateCat(CamProcSeqBuf_t *pProcBuf, int nLen)
{
    CamProcPrintf(pProcBuf,"VDEC bitrate is %d\n",gVDecBitrateVal);
}
void VDECBitrateEcho(char *pProcBuf, int nLen)
{
    CamOsPrintf("VDEC pProcBuf=%s,len=%d\n",pProcBuf,nLen);
    gVDecBitrateVal = atoi(pProcBuf);
}

int CamProcWrapperTest(CLI_t * pCli, char * p)
{
    unsigned int nParam;
    struct CamProcDirEntry_t *pTmpEntry;

    if(CliTokenCount(pCli) != 1) {
        return eCLI_PARSE_ERROR;
    }

    if (CliTokenPopNum(pCli, &nParam, 0) != eCLI_PARSE_OK) {
        return eCLI_PARSE_ERROR;
    }


    if(nParam == 1) {
        //==================Create VENC==================
        gpVENCRootDir = CamProcMkdir("VENC",NULL);

        if(!gpVENCRootDir) {
            cliPrintf("%s L:%d, Mkdir fail in CamProcMkdir\n", __FUNCTION__,__LINE__);
        }

        pTmpEntry = CamProcCreate("FPS", 0, gpVENCRootDir, VENCFpsCat, VENCFpsEcho);

        if(!pTmpEntry) {
            cliPrintf("%s L:%d, Create entry fail in CamProcCreate\n", __FUNCTION__,__LINE__);
        }

        gpVENCSubDir1 = CamProcMkdir("Entry1", gpVENCRootDir);

        if(!gpVENCSubDir1) {
            cliPrintf("%s L:%d, Mkdir fail in CamProcMkdir\n", __FUNCTION__,__LINE__);
        }

        pTmpEntry = CamProcCreate("Resolution", 0, gpVENCSubDir1, VENCResolutionCat, VENCResolutionEcho);

        if(!pTmpEntry) {
            cliPrintf("%s L:%d, Create entry fail in CamProcCreate\n", __FUNCTION__,__LINE__);
        }

        gpVENCSubDir2 = CamProcMkdir("Entry2", gpVENCSubDir1);

        if(!gpVENCSubDir2) {
            cliPrintf("%s L:%d, Mkdir fail in CamProcMkdir\n", __FUNCTION__,__LINE__);
        }

        pTmpEntry = CamProcCreate("Bitrate", 0, gpVENCSubDir2, VENCBitrateCat, VENCBitrateEcho);

        if(!pTmpEntry) {
            cliPrintf("%s L:%d, Create entry fail in CamProcCreate\n", __FUNCTION__,__LINE__);
        }

        //==================Create VDEC==================
        gpVDECRootDir = CamProcMkdir("VDEC",NULL);

        if(!gpVDECRootDir) {
            cliPrintf("%s L:%d, Mkdir fail in CamProcMkdir\n", __FUNCTION__,__LINE__);
        }

        pTmpEntry = CamProcCreate("Dec_FPS", 0, gpVDECRootDir, VDECFpsCat, VDECFpsEcho);

        if(!pTmpEntry) {
            cliPrintf("%s L:%d, Create entry fail in CamProcCreate\n", __FUNCTION__,__LINE__);
        }

        pTmpEntry = CamProcCreate("Dec_Res", 0, gpVDECRootDir, VDECResolutionCat, VDECResolutionEcho);

        if(!pTmpEntry) {
            cliPrintf("%s L:%d, Create entry fail in CamProcCreate\n", __FUNCTION__,__LINE__);
        }

        pTmpEntry = CamProcCreate("Dec_VBR", 0, gpVDECRootDir, VDECBitrateCat, VDECBitrateEcho);

        if(!pTmpEntry) {
            cliPrintf("%s L:%d, Create entry fail in CamProcCreate\n", __FUNCTION__,__LINE__);
        }
    }
    else if (nParam == 2) {

        //Remove method can be one of below :
        //==================Remove VENC==================
        //1.remove all sub entries/nodes by only one step
        CamProcRemoveEntry("VENC",NULL);

        //==================Remove VDEC==================
        //2-1.remove sub-nodes first
        CamProcRemoveEntry("Dec_FPS",gpVDECRootDir);
        CamProcRemoveEntry("Dec_Res",gpVDECRootDir);
        CamProcRemoveEntry("Dec_FPS",gpVDECRootDir);//Just test double free case
        CamProcRemoveEntry("Dec_VBR",gpVDECRootDir);
        //2-2.then remove directory entries
        CamProcRemoveEntry("VDEC",NULL);
    }
    else {
        return eCLI_PARSE_ERROR;
    }

    return eCLI_PARSE_OK;
}

SS_RTOS_CLI_CMD(proctest,
        "Proc wrapper test",
        "param : 1 to create nodes,2 to remove nodes",
        CamProcWrapperTest);
